﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Data;
using System.Net;
using System.IO;

namespace AHOBPR_Job_Runner
{
    public class JsonFormParser : LoggedJob
    {
        protected override String LogFileName { get { return "AHOBPR_Job_Runner.log"; } }
        public override string Id { get { return "FP"; } }

        public override void Run()
        {
            base.StartLog();
            LogMessageToFile("Starting AHOBPR Json Form Parser...");
            base.CheckDiskSpace();

         //   string sqlConnectionString = System.Configuration.ConfigurationSettings.AppSettings["SQLServerConnectionString"];
            string sqlConnectionString = System.Configuration.ConfigurationManager.AppSettings["SQLServerConnectionString"];
            using (SqlConnection dbConnection = new SqlConnection(sqlConnectionString))
            {
                try
                {
                    dbConnection.Open();
                    if (dbConnection.State == ConnectionState.Open)
                    {
                        LogMessageToFile("The SqlConnection is open.");
                    }
                    else
                    {
                        LogMessageToFile("ERROR: Unabale to open a connection to SQL.");
                        return;
                    }

                    LogMessageToFile("Deleting the invalid records from queue table...");
                   
                   

                    // Process queue
                    LogMessageToFile("Processing records from queue table...");
                    int totalRecords = 0;
                    String sqlText = "SELECT A.[JSON_QUEUE_ID] ";
                    sqlText = sqlText + "FROM [AHOBPR].[JSON_QUEUE] A,  AHOBPR.REGISTRANT_JSON B ";
                    sqlText = sqlText + "WHERE A.REGISTRANT_JSON_ID = B.REGISTRANT_JSON_ID ";
                    sqlText = sqlText + "AND B.OBJECT_TYPE = 'form' ";
                    SqlCommand sqlCmd = new SqlCommand(sqlText, dbConnection);
                    try
                    {
                        using (SqlDataReader dataReader = sqlCmd.ExecuteReader())
                        {
                            while (dataReader.Read())
                            {
                                string queueId = dataReader["JSON_QUEUE_ID"].ToString();
                                WebRequest request = WebRequest.Create(System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + queueId);
                                LogMessageToFile("REST service url: " + System.Configuration.ConfigurationManager.AppSettings["RestServiceUrl"] + queueId);
                                request.Method = "GET";
                                request.ContentType = @"application/json; charset=utf-8";
                       
                                String secretKey = System.Configuration.ConfigurationManager.AppSettings["secretKey"];
                                request.Headers.Add("Authorization", "Basic " + secretKey);
                                
                                //Set the timeout to 5 minutes:
                                request.Timeout = 5 * 60 * 1000;

                                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                                string jsonResponse = string.Empty;
                                using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                                {
                                    jsonResponse = sr.ReadToEnd();
                                    LogMessageToFile("Response from REST service: " + jsonResponse);
                                }
                               
                                totalRecords++;
                            }
                        }

                        dbConnection.Close();
                        LogMessageToFile("Processed " + totalRecords + " json records.");
                        LogMessageToFile("The SqlConnection is closed.");
                        LogMessageToFile("AHOBPR Json Parser execution is completed.");
                    }
                    catch (Exception e)
                    {
                        LogErrorMessage(e);
                    }
                }
                catch (Exception ex)
                {
                    LogErrorMessage(ex);
                    LogMessageToFile("AHOBPR Json Parser execution unsuccessful!");
                    return;
                }
            }
        }
    }
}
